#!/usr/bin/env python3
'''
Copyright (C) 2026, WAFW00F Developers.
See the LICENSE file for copying permission.
'''

NAME = 'ModSecurity (SpiderLabs)'


def is_waf(self):
    if check_schema_01(self):
        return True

    if check_schema_02(self):
        return True

    if check_schema_03(self):
        return True

    return False


def check_schema_01(self):
    if self.matchHeader(('Server', r'(mod_security|Mod_Security|NOYB)')):
        return True

    if self.matchContent(r'This error was generated by Mod.?Security'):
        return True

    if self.matchContent(r'rules of the mod.security.module'):
        return True

    if self.matchContent(r'mod.security.rules triggered'):
        return True

    if self.matchContent(r'Protected by Mod.?Security'):
        return True

    if self.matchContent(r'/modsecurity[\-_]errorpage/'):
        return True

    if self.matchContent(r'modsecurity iis'):
        return True

    return False


def check_schema_02(self):
    if not self.matchReason('ModSecurity Action'):
        return False

    if not self.matchStatus(403):
        return False

    return True


def check_schema_03(self):
    if not self.matchReason('ModSecurity Action'):
        return False

    if not self.matchStatus(406):
        return False

    return True
