// Ripped from https://github.com/Ch0pin/medusa/ and modified to fit Androguard packets

colorLog('[+] LOADING WEBVIEWS/WEBVIEWS.JS',{c: Color.Red});

var webView = Java.use('android.webkit.WebView');
var webSettings = Java.use('android.webkit.WebSettings');

webSettings.setAllowContentAccess.implementation = function(allow){
    agPacket({allow: allow}).send();
    return this.setAllowContentAccess(allow);
}

webSettings.setAllowFileAccess.implementation = function(allow){
    agPacket({allow: allow}).send();
    return this.setAllowFileAccess(allow);

}
webSettings.setAllowFileAccessFromFileURLs.implementation = function(allow){
    agPacket({allow: allow}).send();
    return this.setAllowFileAccessFromFileURLs(allow);
}

webSettings.setAllowUniversalAccessFromFileURLs.implementation = function(allow){
    agPacket({allow: allow}).send();
    return this.setAllowUniversalAccessFromFileURLs(allow);

}
webSettings.setJavaScriptEnabled.implementation = function(allow){
    agPacket({allow: allow}).send();
    return this.setJavaScriptEnabled(allow);
}


webView.setVisibility.implementation = function(a){
    agPacket({a: a}).send();
    return this.setVisibility(a);
    
}
webView.addJavascriptInterface.implementation = function(object, name){
    agPacket({className: object.$className, name:name}).send();
    this.addJavascriptInterface(object,name);
}


webView.evaluateJavascript.implementation = function(script, resultCallback){
    agPacket({script: script}).send();
    this.evaluateJavascript(script, resultCallback);
}

webView.getOriginalUrl.implementation = function() {
    var ret =  this.getOriginalUrl();
    agPacket({ret: ret}).send();
    return ret;
}

webView.getUrl.implementation = function() {
    var ret = this.getUrl();
    agPacket({webview: dumpWebview(this), ret: ret}).send();
    return this.getUrl();
}

webView.loadData.implementation = function(data, mimeType, encoding){
    agPacket({data: data, mimeType, mimeType, encoding: encoding}).send();
    this.loadData(data,mimeType,encoding);
}

webView.loadDataWithBaseURL.implementation = function(baseUrl,  data,  mimeType,  encoding,  historyUrl){
    agPacket({baseUrl: baseUrl, data: data, mimeType: mimeType, encoding: encoding, historyUrl: historyUrl}).send();
    this.loadDataWithBaseURL(baseUrl, data, mimeType, encoding, historyUrl);
}

webView.loadUrl.overload('java.lang.String', 'java.util.Map').implementation = function(url, additionalHttpHeaders) {
    agPacket({webview: dumpWebview(this), url: url}).send();
    this.setWebContentsDebuggingEnabled(true);

    this.loadUrl(url,additionalHttpHeaders);
}


webView.loadUrl.overload('java.lang.String').implementation = function(url){
    agPacket({webview: dumpWebview(this), url: url}).send();
    this.setWebContentsDebuggingEnabled(true);
    this.loadUrl(url);
}

webView.postUrl.implementation = function (url, postData){
    agPacket({url: url, postData: postData}).send();
    this.postUrl(url,postData);
}

webView.removeJavascriptInterface.implementation = function(name){
    agPacket({name: name}).send();
    this.removeJavascriptInterface(name);
}

webView.setWebViewClient.implementation = function(client){
    agPacket({className: client.$className}).send();
    this.setWebViewClient(client);
}